package com.iplatform.base;

import com.walker.file.FileInfo;
import com.walker.file.FileStoreType;

import java.io.InputStream;
import java.util.List;

/**
 * 文件操作提供者定义，由第三方实现文件管理功能，包括:上传、下载、获取文件信息等。
 * @author 时克英
 * @date 2023-02-15
 */
public interface FileOperateSpi {

    /**
     * 清除给定文件地址的CDN前缀。如：https://qnyun.com/oss/12345678
     * <pre>
     *     去掉前缀后，只剩下"12345678"
     * </pre>
     * @param path 给定的文件资源地址
     * @return
     * @date 2023-05-17
     */
    String clearCdnPrefix(String path);

    /**
     * 获取上传文件的CDN地址，根据使用的不同第三方服务从配置中查找。
     * @return
     * @date 2023-05-17
     */
    String getCdnUrl();

    FileInfo uploadFileToLocal(InputStream inputStream
            , String fileName, String groupId, long fileSize, Integer businessType, String owner) throws Exception;
    FileInfo[] uploadFileToLocal(InputStream[] inputStream
            , String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws Exception;

    FileInfo uploadFileToFtp(InputStream inputStream
            , String fileName, String groupId, long fileSize, Integer businessType, String owner) throws Exception;
    FileInfo[] uploadFileToFtp(InputStream[] inputStream
            , String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws Exception;

    FileInfo uploadFileToOss(InputStream inputStream
            , String fileName, String groupId, long fileSize, Integer businessType, String owner, FileStoreType ossType) throws Exception;
    FileInfo[] uploadFileToOss(InputStream[] inputStream
            , String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner, FileStoreType ossType) throws Exception;

    @Deprecated
    FileInfo uploadFileToSystem(InputStream inputStream, String fileName, String groupId, long fileSize) throws Exception;

    @Deprecated
    FileInfo uploadFileToFtp(InputStream inputStream, String fileName, String groupId, long fileSize) throws Exception;

    FileInfo getFileInfo(long id);

    List<FileInfo> getFileInfoList(List<String> ids);

    /**
     * 返回本地文件系统存储根目录，如: d:/tmp/
     * @return
     * @date 2023-02-15
     */
    String getFileRootConfig();

    /**
     * 调用远程上传文件，是否按照本地方式处理。
     * <pre>
     *     1)该选项为了适应没有FTP等服务的情况，特别是在开发过程，如果设置为：true 则调用远程上传方法后文件仍然保存在本地。
     *     2)如果生产环境存在合适的文件存储服务，则需要设置为：false
     * </pre>
     * @return
     * @date 2023-07-03
     */
    boolean isRemoteAsLocal();
}
