package com.iplatform.base;

import com.walker.connector.LocalAddress;
import com.walker.db.DatabaseType;
import com.walker.db.TableInfo;
import com.walker.db.page.GenericPager;
import com.walker.dbmeta.DatabaseMetaEngine;
import com.walker.dbmeta.FieldInfo;
import com.walker.dbmeta.support.DamengMetaEngine;
import com.walker.dbmeta.support.MySQLMetaEngine;
import com.walker.dbmeta.support.OracleMetaEngine;
import com.walker.dbmeta.support.PostgresMetaEngine;
import com.walker.dbmeta.support.SqlserverMetaEngine;
import com.walker.security.SystemLogMan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 定义本地数据库元数据引擎对象。<p></p>
 * 用于查询数据库中表和字段记录。
 * @author 时克英
 * @date 2022-11-22
 */
public class LocalDatabaseMetaEngine {

    private DatabaseMetaEngine engine;

    private LocalAddress localAddress;

    public void setLocalAddress(LocalAddress localAddress) {
        if(localAddress == null){
            throw new IllegalArgumentException("LocalAddress 必须提供");
        }
        this.localAddress = localAddress;
        SystemLogMan.getInstance().checkMan();
    }

    public void setDatabaseType(DatabaseType databaseType){
        if(databaseType == DatabaseType.DERBY){
            throw new UnsupportedOperationException("不支持该数据库：" + databaseType.name());
        } else if(databaseType == DatabaseType.MYSQL){
            engine = new MySQLMetaEngine();

        } else if(databaseType == DatabaseType.ORACLE){
            engine = new OracleMetaEngine();

        } else if(databaseType == DatabaseType.POSTGRES){
            engine = new PostgresMetaEngine();

        } else if(databaseType == DatabaseType.SQLSERVER){
            engine = new SqlserverMetaEngine();

        } else if(databaseType == DatabaseType.DAMENG){
            // 2023-03-03
            engine = new DamengMetaEngine();

        } else
            throw new IllegalArgumentException("unsupported database type: " + databaseType.name());
        System.out.println("创建:" + engine.getClass().getName());
    }

    public List<FieldInfo> getFieldsObject(String tableName){
        return engine.getFieldsObject(this.localAddress, tableName);
    }

    public List<String> getTableNamesByLike(String tableNameLike){
        return engine.getTableNamesByLike(this.localAddress, tableNameLike);
    }

    /**
     * 分页返回表信息集合。当前页信息通过对象: ListPageContext.getCurrentPageIndex()方法获得。
     * @param tableNameLike 表名模糊查询，如果为空字符串则查询所有。
     * @return
     * @date 2022-11-22
     */
    public GenericPager<TableInfo> queryPageTableNamesByLike(String tableNameLike
//			, int pageIndex, int pageSize
    ){
        return this.engine.queryPageTableNamesByLike(this.localAddress, tableNameLike);
    }

    /**
     * 返回指定表元数据信息。
     * @param tableName 表名称
     * @return
     * @date 2022-11-26
     */
    public TableInfo queryOneTableInfo(String tableName){
        List<String> tableList = new ArrayList<>(2);
        tableList.add(tableName);
        Map<String, TableInfo> map = this.engine.getTableRows(this.localAddress, tableList);
        if(map == null || map.size() == 0){
            return null;
        }
        return map.get(tableName);
    }
}
