package com.iplatform.base;

import com.iplatform.base.pojo.form.FormData;
import com.iplatform.base.pojo.form.FormDataItem;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_group_data;
import com.iplatform.model.vo.SystemGroupVo;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 新界面，重构平台定义的基础控制器。
 * @author 时克英
 * @date 2023-05-15
 */
public abstract class PlatformAdapterController extends SystemController{

    protected SystemGroupCache getSystemGroupCache(){
        return BeanContextAware.getBeanByType(SystemGroupCache.class);
    }

    private GroupServiceImpl getGroupService(){
        return BeanContextAware.getBeanByType(GroupServiceImpl.class);
    }

    /**
     * 根据分组项目ID，返回转换后的对象。
     * @param groupDataId
     * @param clazz
     * @param cdnUrl
     * @return
     * @param <T>
     * @date 2023-09-11
     */
    protected <T> T acquireGroupDataNormal(int groupDataId, Class<T> clazz, String cdnUrl){
        S_group_data groupData = this.getGroupService().queryGroupData(groupDataId);
        if(groupData == null || groupData.getStatus().intValue() == 0){
            return null;
        }

        try {
            FormData formData = JsonUtils.jsonStringToObject(groupData.getValue(), FormData.class);
            if(StringUtils.isEmptyList(formData.getFields())){
                return null;
            }
            HashMap<String, Object> map = new HashMap<>();
            for(FormDataItem item : formData.getFields()){
                if(item.getName().equals(Constants.GROUP_DATA_IMAGE)){
                    map.put(item.getName(), cdnUrl + item.getValue());
                } else {
                    map.put(item.getName(), item.getValue());
                }
            }
            map.put("id", groupData.getId());
            String json = JsonUtils.objectToJsonString(map);
            return JsonUtils.jsonStringToObject(json, clazz);

        } catch (Exception ex){
            throw new PlatformRuntimeException("S_group_data.value转FormData错误：" + ex.getMessage(), ex);
        }
    }

    /**
     * 返回分组包含的动态添加项列表集合。
     * <pre>
     *     1) 目前，在充值功能中使用，显示充值套餐列表。
     * </pre>
     * @param groupId 分组ID
     * @param status 是否可用
     * @param clazz 转换结果对象
     * @param cdnUrl 图片前缀
     * @return
     * @param <T>
     * @date 2023-09-11
     */
    protected <T> List<T> acquireGroupDataList(int groupId, boolean status, Class<T> clazz, String cdnUrl){
        SystemGroupVo vo = this.getSystemGroupCache().get(groupId);
        if(vo == null){
            throw new IllegalStateException("缓存中未找到分组记录，groupId = " + groupId);
        }
        List<S_group_data> groupDataList = vo.getGroupDataList();
        if(StringUtils.isEmptyList(groupDataList)){
            return null;
        }

        List<T> arrayList = new ArrayList<>();

        try{
            FormData formData = null;
            for(S_group_data data : groupDataList){
                formData = JsonUtils.jsonStringToObject(data.getValue(), FormData.class);
                if(StringUtils.isEmptyList(formData.getFields())){
                    continue;
                }
                if(status && data.getStatus().intValue() == 0){
                    continue;
                }

                HashMap<String, Object> map = new HashMap<>();
                T t;
                for(FormDataItem item : formData.getFields()){
                    if(item.getName().equals(Constants.GROUP_DATA_IMAGE)){
                        map.put(item.getName(), cdnUrl + item.getValue());
                    } else {
                        map.put(item.getName(), item.getValue());
                    }
                }
                map.put("id", data.getId());
                String json = JsonUtils.objectToJsonString(map);
                t = JsonUtils.jsonStringToObject(json, clazz);
                arrayList.add(t);
            }
            return arrayList;
        } catch (Exception ex){
            throw new PlatformRuntimeException("S_group_data.value转FormData错误：" + ex.getMessage(), ex);
        }
    }

    /**
     * 根据分组ID，返回分组包含的数据项配置集合信息。例如：
     * <pre>
     *     1)配置的APP首页底部导航。
     * </pre>
     * @param groupId 分组ID
     * @return
     * @date 2023-06-23
     */
    protected List<HashMap<String, Object>> acquireGroupDataConfigList(int groupId, String cdnUrl){
        SystemGroupVo vo = this.getSystemGroupCache().get(groupId);
        if(vo == null){
            throw new IllegalStateException("缓存中未找到分组记录，groupId = " + groupId);
        }
        List<S_group_data> groupDataList = vo.getGroupDataList();
        if(StringUtils.isEmptyList(groupDataList)){
            return new ArrayList<>(1);
        }

        List<HashMap<String, Object>> arrayList = new ArrayList<>();

        try {
            FormData formData = null;
            for (S_group_data data : groupDataList) {
                formData = JsonUtils.jsonStringToObject(data.getValue(), FormData.class);
                if(StringUtils.isEmptyList(formData.getFields())){
                    continue;
                }

                HashMap<String, Object> map = new HashMap<>();
                for(FormDataItem item : formData.getFields()){
                    if(item.getName().equals(Constants.GROUP_DATA_IMAGE)){
                        map.put(item.getName(), cdnUrl + item.getValue());
                    } else {
                        map.put(item.getName(), item.getValue());
                    }
                }
                map.put("id", data.getId());
                arrayList.add(map);
            }
            return arrayList;

        } catch (Exception ex){
            throw new PlatformRuntimeException("S_group_data.value转FormData错误：" + ex.getMessage(), ex);
        }
    }

    /**
     * 返回用户归属值，如果是平台为'-1'，如果为租户（商户）则为定义的商户ID。
     * <pre>
     *     注意要点：
     *     1）因为系统框架中用户是长整形（Long），但商户中是（int）因此在实际添加商户数据时，需要按照序列来计算，这样只需要整形即可。
     * </pre>
     * @return
     * @date 2023-05-15
     */
//    protected int getOwner(){
//        S_user_core user = this.getCurrentUser();
//        int userType = user.getUser_type();
//        if(userType == UserType.TYPE_SUPER_MERCHANT || userType == UserType.TYPE_MERCHANT_ADMIN){
//            return user.getMer_id().intValue();
////            throw new UnsupportedOperationException("对于其他租户（商户）归属应为：mer_id");
//        }
//        return Constants.OWNER_PLATFORM;
//    }
}
