package com.iplatform.base;

import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.ApplicationCallback;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.TokenException;
import com.walker.web.UserPrincipal;

/**
 * 平台登录回调接口定义，便于支持多种用户(或设备)使用相同方式登录系统。
 * @author 时克英
 * @date 2023-01-26
 */
public interface PlatformLoginCallback extends ApplicationCallback {

    /**
     * 是否检测验证码，该方法意思是:在提交登录时，是否要验证。
     * <pre>
     *     1)例如:在PC端会存在验证码。
     *     2)在APP端，通过短信登录时，不会有验证码(只会在生成短信验证码时才有验证操作)
     * </pre>
     * @return
     */
    boolean isValidateCaptcha();

    /**
     * 根据用户登录ID，返回用户登录基本信息。<p></p>
     *
     * @param loginId
     * @return object[0] = S_user_core user, object[1] = List<String> roleIdList
     */
    Object[] queryLoginUser(String loginId);

    /**
     * 校验密码回调方法。
     * @param userPrincipal
     * @return
     */
    boolean validatePassword(UserPrincipal<S_user_core> userPrincipal);

    /**
     * 注销回调方法，当用户退出时触发调用。
     * @param token 客户端提交的token
     */
    void onLogout(String token) throws TokenException;

    /**
     * 返回登录回调配置的'验证码提供者'
     * @return
     * @date 2023-03-14
     */
    CaptchaProvider<CaptchaResult> getCaptchaProvider();

    /**
     * 设置登录回调配置的'验证码提供者'，每个登录回调对象都需要配置一个。
     * @param captchaProvider
     * @date 2023-03-14
     */
    void setCaptchaProvider(CaptchaProvider<CaptchaResult> captchaProvider);
}
