package com.iplatform.base;

import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.ApplicationCallback;

/**
 * 用户操作回调接口定义。
 * <pre>
 *     1)业务可以配置实现自己的用户操作回调动作，如：当系统添加用户时，业务要初始设置用户默认积分等。
 *     2)实现该接口后，直接配置为<code>Sping Bean</code> 即可。
 *     3)注意:该方法会在数据库事务中调用，因此业务尽量在回调中只操作数据库，降低时间操作过长风险。
 * </pre>
 * @date 2023-01-05
 */
public interface PlatformUserCallback extends ApplicationCallback {

    /**
     * 当系统创建新用户时，回调该接口
     * @param user
     */
    public void onCreateNewUser(S_user_core user);

    /**
     * 当系统更新用户时，回调该接口
     * @param user
     */
    public void onUpdateUser(S_user_core user);

    /**
     * 当系统删除用户时，回调该接口
     * @param userId
     */
    public void onDeleteUser(long userId);
}
