package com.iplatform.base;

import com.walker.infrastructure.utils.JsonUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 平台定义的业务推送（消息）对象。<p>该对象在业务层使用。</p>
 * @author 时克英
 * @date 2023-04-25
 */
public class PushData implements Serializable {

    @Override
    public String toString(){
        return new StringBuilder("[userId=").append(this.userId)
                .append(", bizId=").append(this.businessId)
                .append(", type=").append(this.businessType)
                .append(", schema=").append(this.schema)
                .append(", title=").append(this.title)
                .append("]").toString();
    }

    public String toJson(){
        try {
            return JsonUtils.objectToJsonString(this);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addParameter(String key, Object value){
        if(this.parameter == null){
            this.parameter = new HashMap<>(2);
        }
        this.parameter.put(key, value);
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getSchema() {
        return schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, Object> getParameter() {
        return parameter;
    }

    public void setParameter(Map<String, Object> parameter) {
        this.parameter = parameter;
    }

    private String userId;
    private String businessId;
    private String businessType;
    private String schema;
    private String title;
    private Map<String, Object> parameter = null;

    public static final String SCHEMA_HTTP = "https://";
    public static final String SCHEMA_APP = "app://";
    public static final String SCHEMA_SYSTEM = "system://";
}
