package com.iplatform.base;

import com.iplatform.base.cache.DictCacheProvider;
import com.iplatform.base.callback.PlatformCallbackPostProcessor;
import com.iplatform.base.di.PlatformDataImportEngine;
import com.walker.cache.CacheProvider;
import com.walker.push.PushManager;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;

import java.util.List;

/**
 * 系统业务bean配置总管理，用于测试在 SystemController 初始化后自动组装一些通用缓存对象。<p></p>
 * 测试通过！
 * @author 时克英
 * @date 2023-03-10
 */
public class RootConfigBean {

    /**
     * 触发自动设置各种公共 Bean 到系统控制器中，不用在创建时手动注入，也不需要依赖 spring的特定注解。
     * @date 2023-03-10
     */
    public void startup(){
        List<SystemController> systemControllerList = this.callbackPostProcessor.getSystemControllerList();
        if(systemControllerList != null){
            for(SystemController controller : systemControllerList){
                controller.setDictCacheProvider(this.dictCacheProvider);
                controller.setDeptCacheProvider(this.deptCacheProvider);
                controller.setUserCacheProvider(this.userCacheProvider);
                controller.setPlatformDataImportEngine(this.platformDataImportEngine);
                controller.setPushManager(this.pushManager);
                controller.setSmsCaptchaProvider(this.smsCaptchaProvider);
                controller.setCaptchaCacheProvider(this.captchaCacheProvider);
            }
            System.out.println("............... | RootConfigBean: startup()");
        }
    }

    public void setCallbackPostProcessor(PlatformCallbackPostProcessor callbackPostProcessor) {
        this.callbackPostProcessor = callbackPostProcessor;
    }

    public void setDeptCacheProvider(DeptCacheProvider deptCacheProvider) {
        this.deptCacheProvider = deptCacheProvider;
    }

    public void setUserCacheProvider(UserCacheProvider userCacheProvider) {
        this.userCacheProvider = userCacheProvider;
    }

    public void setPlatformDataImportEngine(PlatformDataImportEngine platformDataImportEngine) {
        this.platformDataImportEngine = platformDataImportEngine;
    }

    public void setDictCacheProvider(DictCacheProvider dictCacheProvider) {
        this.dictCacheProvider = dictCacheProvider;
    }

    public void setPushManager(PushManager pushManager) {
        this.pushManager = pushManager;
    }

    public void setSmsCaptchaProvider(CaptchaProvider<CaptchaResult> smsCaptchaProvider) {
        this.smsCaptchaProvider = smsCaptchaProvider;
    }

    public void setCaptchaCacheProvider(CacheProvider<String> captchaCacheProvider) {
        this.captchaCacheProvider = captchaCacheProvider;
    }

    private CaptchaProvider<CaptchaResult> smsCaptchaProvider;
    private CacheProvider<String> captchaCacheProvider;

    private PushManager pushManager;
    private PlatformCallbackPostProcessor callbackPostProcessor = null;

    private DeptCacheProvider deptCacheProvider;
    private UserCacheProvider userCacheProvider;
    private PlatformDataImportEngine platformDataImportEngine;
    private DictCacheProvider dictCacheProvider;
}
