package com.iplatform.base;

import com.iplatform.base.exception.LoginException;
import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.model.po.S_user_core;
import com.walker.web.UserPrincipal;

import java.util.List;
import java.util.Map;

/**
 * 安全提供者接口定义。<br>
 * 通过该接口使得 iplatform-base-security 模块可以解耦。
 * @author 时克英
 * @date 2022-11-11
 */
public interface SecuritySpi {

    /**
     * 返回当前登录用户具有的角色ID集合。
     * @return
     */
    List<String> getCurrentUserRoleIdList();

    /**
     * 返回当前登录用户凭证信息
     * @return
     */
    UserPrincipal<S_user_core> getCurrentUserPrincipal();

    /**
     * 返回当前登录用户对象
     * @return
     */
    S_user_core getCurrentUser();

    /**
     * 返回当前登录用户ID
     * @return
     */
    long getCurrentUserId();

    /**
     * 加密给定的明文密码
     * @param password
     * @return 返回密文密码
     */
    String encryptPassword(String password);

    /**
     * 比较给定的密码是否与加密相等。
     * @param rawPassword 原始明文密码
     * @param encodedPassword 加密的密码
     * @return
     */
    boolean matchesPassword(String rawPassword, String encodedPassword);

    /**
     * 是否允许移动端，在登录时手机号不存在直接注册？
     * @return
     * @date 2023-06-28
     */
    boolean isAllowMobileLoginRegister();

    /**
     * 用户登录系统过程方法，抽取该方法可以在自定义登录中灵活使用。
     * @param requestLogin
     * @return
     * @throws LoginException 登录异常抛出提示错误
     * @date 2023-06-28
     */
    Map<String, Object> login(RequestLogin requestLogin) throws LoginException;

    /**
     * 以流程角色登录获取权限，activiti7专用，后续会废弃。
     * @author 时克英
     * @date 2023-03-21
     */
    @Deprecated
    void loginAsWorkflowRole();
}
