package com.iplatform.base;

import com.iplatform.base.exception.LoginException;
import com.iplatform.base.pojo.RequestLogin;

import java.util.Map;

/**
 * 第三方登录（集成）认证。
 * <pre>
 *     1)该接口主要用于第三方系统直接登录平台方式。
 *     2)第三方传递给平台相关参数，然后平台直接登录并生成token给前端。
 * </pre>
 * @date 2023-07-03
 */
public interface ThirdPartyAuthentication {

    /**
     * 调用第三方认证接口，依据参数获得用户详细信息（以便于转换成平台用户身份）
     * @param parameter 第三方提供的参数
     * @return 返回平台登录参数，请求统一登录地址完成（无感）登录
     * @throws LoginException 如果错误抛出异常
     * @date 2023-07-03
     */
    RequestLogin authenticate(Map<String, Object> parameter) throws LoginException;

    /**
     * 返回认证的唯一标识（或名称）
     * @return
     */
    String getName();

    /**
     * 返回认证对象的描述。
     * @return
     */
    String getDescription();
}
