package com.iplatform.base;

/**
 * 微信登录相关配置缓存，目前：ticket、普通 access_token
 * @author 时克英
 * @date 2023-08-23 从电商模块迁移到 base
 */
public interface WechatCacheProvider {

    /**
     * 获取小程序access_token，生成小程序二维码使用。
     * @return
     * @date 2023-09-16
     */
    String getMiniAccessToken();

    /**
     * 返回：JS-SDK的ticket，
     * @return
     */
    String getJsApiTicket();

    /**
     * 获取公共（公众号）accessToken
     * @return
     * @date 2023-07-16
     */
    String getPublicAccessToken();

    /**
     * 设置公共（公众号）accessToken，<p>缓存时间：accessTokenVo.getExpiresIn().longValue() - 1800L</p>
     * @param value
     * @date 2023-07-16
     */
    void putPublicAccessToken(String value, long expiredSeconds);

    /**
     * 缓存ticket，默认：7100 秒后过期。
     * @param value
     */
    void putJsApiTicket(String value);

    /**
     * 设置（小程序）accessToken，<p>缓存时间：accessTokenVo.getExpiresIn().longValue() - 1800L</p>
     * @param value
     * @param expiredSeconds
     * @date 2023-09-16
     */
    void putMiniAccessToken(String value, long expiredSeconds);

    /**
     * 删除（小程序）accessToken.
     * @date 2023-09-16
     */
    void removeMiniAccessToken();
}
