package com.iplatform.base.api;

import com.iplatform.base.PlatformAdapterController;
import com.iplatform.base.service.UserDeptApiServiceImpl;
import com.iplatform.model.to.UserAndDeptTo;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 提供对外接口，实现对平台机构人员的操作。
 * @author 时克英
 * @date 2023-06-06
 */
@RestController
@RequestMapping("/api/platform/user_dept")
public class UserAndDeptApi extends PlatformAdapterController
//        implements UserAndDeptServiceApi
{

    private UserDeptApiServiceImpl userDeptApiService;

    @Autowired
    public UserAndDeptApi(UserDeptApiServiceImpl userDeptApiService){
        this.userDeptApiService = userDeptApiService;
    }

    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public ResponseValue execInsertTopOrgAndAdmin(@RequestBody UserAndDeptTo userAndDeptTo) {
        long loginId = this.getCurrentUserId();
        userAndDeptTo.setCreateId(String.valueOf(loginId));
        if(this.logger.isDebugEnabled()){
            logger.debug(userAndDeptTo.toString());
        }
        return this.userDeptApiService.execInsertTopOrgAndAdmin(userAndDeptTo);
    }
}
