package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.pojo.form.FormData;
import com.iplatform.base.pojo.form.FormDataItem;
import com.iplatform.base.service.ConfigFormServiceImpl;
import com.iplatform.base.util.ConfigFormValidateUtils;
import com.iplatform.model.po.S_config_form;
import com.iplatform.model.vo.ConfigFormItemConfigRegListVo;
import com.iplatform.model.vo.ConfigFormItemVo;
import com.iplatform.model.vo.ConfigFormVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 自定义表单缓存。
 * <p>1、因为这个数据不会动态变动，因此不需要Redis负载支持。</p>
 * @author 时克英
 * @date 2023-05-18
 */
public class FormCacheProvider extends AbstractCacheProvider<S_config_form> {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~~ 用于验证配置表单的相关方法，后续需要增加表单引擎（对象）来单独处理，
    //~~ 现在临时使用缓存对象处理。2023-05-20
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 校验提交的表单是否正确。
     * <pre>1) 当前在功能：分组（组合数据）添加数据项时被调用。</pre>
     * @param formData
     * @date 2023-05-20
     */
    public void validateForm(FormData formData){
        //循环取出item数据， 组合成 key => val 的map格式
        Map<String, String> map = new HashMap<>();
        String formItemValue = null;
        for (FormDataItem formDataItem : formData.getFields()) {
            // 2023-05-21 把value中json转字符串时，包含的：\"去掉。
            // 由于还没有使用到，需要后续评估看用那种方法能获取值。
//            formItemValue = formDataItem.getValue();
//            if(StringUtils.isNotEmpty(formItemValue)){
//                formDataItem.setValue(formItemValue.replaceAll("\"", StringUtils.EMPTY_STRING));
//            }

            // 算法临时缓存
            map.put(formDataItem.getName(), formDataItem.getValue());
        }

        //取出表单模型的数据
        S_config_form form = this.getCacheData(formData.getId().toString());

        //解析表单规则进行验证
        ConfigFormVo systemConfigFormVo = null;
        try {
            systemConfigFormVo = JsonUtils.jsonStringToObject(form.getContent(), ConfigFormVo.class);
        } catch (Exception e) {
            logger.error("formData.getId()=" + formData.getId() + ", " + e.getMessage(), e);
            throw new PlatformRuntimeException("模板表单 【" + form.getName() + "】 内容不正确，请检查JSON格式！", e);
        }

//        ConfigFormItemVo configFormItemVo;
//        for (String item : systemConfigFormVo.getFields()) {
        for (ConfigFormItemVo configFormItemVo : systemConfigFormVo.getFields()) {
//            systemConfigFormItemVo = JSONObject.parseObject(item, SystemConfigFormItemVo.class);
//            try {
//                configFormItemVo = JsonUtils.jsonStringToObject(item, ConfigFormItemVo.class);
//            } catch (Exception e) {
//                throw new PlatformRuntimeException("ConfigFormItemVo转换错误:" + item, e);
//            }
            String model = configFormItemVo.get__vModel__(); //字段 name

            if(configFormItemVo.get__config__().getRequired() && map.get(model).equals(StringUtils.EMPTY_STRING)) {
                throw new PlatformRuntimeException(configFormItemVo.get__config__().getLabel() + "不能为空！");
            }
            //正则验证
            checkRule(configFormItemVo.get__config__().getRegList(), map.get(model),  configFormItemVo.get__config__().getLabel());
        }
    }

    /**
     * 验证item规则
     * @param regList List<SystemConfigFormItemConfigRegListVo 正则表达式列表
     * @param value String 验证的值
     * @param name String 提示语字段名称

     * @since 2020-04-16
     */
    private void checkRule(List<ConfigFormItemConfigRegListVo> regList, String value, String name) {
        if(regList.size() > 0) {
            for (ConfigFormItemConfigRegListVo systemConfigFormItemConfigRegListVo : regList) {
                if(!ConfigFormValidateUtils.regular(value, name, systemConfigFormItemConfigRegListVo.getPattern())) {
                    throw new PlatformRuntimeException(systemConfigFormItemConfigRegListVo.getMessage());
                }
            }
        }
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ end ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    @Override
    protected int loadDataToCache(Cache cache) {
        List<S_config_form> hosts = this.configFormService.selectAll(new S_config_form());
        if(!StringUtils.isEmptyList(hosts)){
            for(S_config_form h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_FORM;
    }

    @Override
    public Class<?> getProviderType() {
        return S_config_form.class;
    }

    public void setConfigFormService(ConfigFormServiceImpl configFormService) {
        this.configFormService = configFormService;
    }

    private ConfigFormServiceImpl configFormService;
}
