package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;

import java.util.HashMap;
import java.util.Map;

/**
 * 验证码(本地)缓存实现。
 * @author 时克英
 * @date 2022-11-07
 */
public class LocalCaptchaCacheProvider extends AbstractCacheProvider<String> {

    private Map<String, Long> captchaKeyExpiredMap = new HashMap<>();

    public LocalCaptchaCacheProvider(){
        this.runClearDirtyCacheTask();
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_CAPTCHA;
    }

    @Override
    public Class<?> getProviderType() {
        return String.class;
    }

    @Override
    public void putCacheData(String key, String data, long expiredSeconds){
        this.putCacheData(key, data);
        this.captchaKeyExpiredMap.put(key, expiredSeconds);
    }

    private void runClearDirtyCacheTask(){
        logger.info("启动定时任务，定期清理过期的推送临时数据，但暂未实现。");
    }
}
