package com.iplatform.base.cache;

import com.iplatform.base.CategoryCacheProvider;
import com.iplatform.base.Constants;
import com.iplatform.base.service.CategoryServiceImpl;
import com.iplatform.base.util.CategoryUtils;
import com.iplatform.base.util.cache.CategorySortComparator;
import com.iplatform.model.po.S_category;
import com.iplatform.model.vo.CategoryTreeVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalCategoryCacheProvider extends AbstractCacheProvider<S_category> implements CategoryCacheProvider {

    private final CategorySortComparator sortComparator = new CategorySortComparator();

    @Override
    public List<CategoryTreeVo> getTree(Integer type, Integer status, String name, List<Integer> categoryIdList, int owner) {
        List<S_category> allTree = new ArrayList<>();
        S_category tempCategory = null;

        for(Iterator<Cachable> it = this.getCache().getIterator(); it.hasNext();){
            tempCategory = (S_category) it.next().getValue();
//            if(owner != tempCategory.getOwner().intValue()){
//                continue;
//            }
//            if(type != null && type.intValue() != tempCategory.getType().intValue()){
//                continue;
//            }
//            if(status != null && status.intValue() != tempCategory.getStatus().intValue()){
//                continue;
//            }
//            if(!StringUtils.isEmptyList(categoryIdList) && !categoryIdList.contains(tempCategory.getId())){
//                logger.debug("不包含在给定的集合中'categoryIdList'");
//                continue;
//            }
            if(CategoryUtils.isCondition(tempCategory, type, status, name, categoryIdList, owner)){
                allTree.add(tempCategory);
            }
        }

        return CategoryUtils.acquireListTree(allTree, sortComparator);
//        // 重新排序
//        Collections.sort(allTree, sortComparator);
//
//        //
//        List<CategoryTreeVo> treeList = new ArrayList<>();
//        if(allTree.size() == 0){
//            return treeList;
//        }
//
//        //
//        for (S_category category : allTree) {
//            treeList.add(CategoryUtils.toCategoryTreeVo(category));
//        }
//
//        Map<Integer, CategoryTreeVo> map = new HashMap<>(treeList.size());
//        //ID 为 key 存储到map 中
//        for (CategoryTreeVo categoryTreeVo : treeList) {
//            map.put(categoryTreeVo.getId(), categoryTreeVo);
//        }
//
//        List<CategoryTreeVo> list = new ArrayList<>();
//        CategoryTreeVo parentTree = null;
//        for (CategoryTreeVo tree : treeList) {
//            //子集ID返回对象，有则添加。
//            parentTree = map.get(tree.getPid());
//            if (parentTree != null) {
//                parentTree.getChild().add(tree);
//            } else {
//                list.add(tree);
//            }
//        }
//        return list;
    }

    @Override
    public List<CategoryTreeVo> getListTree(Integer type, Integer status, String name, int owner) {
        if(StringUtils.isNotEmpty(name)){
            try {
                name = URLDecoder.decode(name, StringUtils.DEFAULT_CHARSET_UTF8);
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return getTree(type, status, name, null, owner);
    }

    @Override
    public S_category get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(S_category category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(S_category category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<S_category> data = this.categoryService.selectAll(new S_category());
        if(!StringUtils.isEmptyList(data)){
            for(S_category d : data){
                cache.put(String.valueOf(d.getId()), d);
            }
            return data.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_CATEGORY;
    }

    @Override
    public Class<?> getProviderType() {
        return S_category.class;
    }

    public void setCategoryService(CategoryServiceImpl categoryService) {
        this.categoryService = categoryService;
    }

    private CategoryServiceImpl categoryService;
}
