package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.model.po.S_host;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.PubService;

import java.util.List;

/**
 * 主机资源缓存定义（本机内存缓存）实现。
 * @author 时克英
 * @date 2022-09-20
 */
public class LocalHostCacheProvider extends AbstractCacheProvider<S_host> {

    private PubService pubService;

    public void setPubService(PubService pubService) {
        this.pubService = pubService;
    }

    public LocalHostCacheProvider(){
        this.setLoadPage(false);
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<S_host> hosts = this.pubService.selectAll(new S_host());
        if(!StringUtils.isEmptyList(hosts)){
            for(S_host h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_HOST;
    }

    @Override
    public Class<?> getProviderType() {
        return S_host.class;
    }
}
