package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.NotificationTemplateCache;
import com.iplatform.base.NotifyConstants;
import com.iplatform.base.service.NotificationServiceImpl;
import com.iplatform.model.po.SfNotification;
import com.iplatform.model.po.SfTemplateMessage;
import com.iplatform.model.vo.NotificationTemplateVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;
import java.util.Map;

public class LocalNotificationTemplateCache extends AbstractCacheProvider<NotificationTemplateVo> implements NotificationTemplateCache {

    @Override
    public NotificationTemplateVo get(String mark) {
        return this.getCacheData(mark);
    }

    @Override
    public void save(NotificationTemplateVo category) {
        this.putCacheData(category.getName(), category);
    }

    @Override
    public void update(NotificationTemplateVo category) {
        this.updateCacheData(category.getName(), category);
    }

    @Override
    public void remove(String mark) {
        this.removeCacheData(mark);
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<SfNotification> notificationList = this.notificationService.selectAll(new SfNotification());
        if(!StringUtils.isEmptyList(notificationList)){
            Map<Long, SfTemplateMessage> templateMessageMap = this.notificationService.queryTemplateIdMap();
            if(templateMessageMap.size() == 0){
                logger.warn("提醒模板未找到任何有效数据");
                return 0;
            }
            for(SfNotification h : notificationList){
                NotificationTemplateVo vo = new NotificationTemplateVo();
                vo.setName(h.getMark());
                if(h.getIsWechat().intValue() == NotifyConstants.SWITCH_OPEN){
                    vo.setWechat(true);
                    vo.setWechatId(h.getWechatId());
                    vo.setWechatTempId(templateMessageMap.get(h.getWechatId().longValue()).getTempId());
                }
                if(h.getIsRoutine().intValue() == NotifyConstants.SWITCH_OPEN){
                    vo.setRoutine(true);
                    vo.setRoutineId(h.getRoutineId());
                    vo.setRoutineTempId(templateMessageMap.get(h.getRoutineId().longValue()).getTempId());
                }
                if(h.getIsSms().intValue() == NotifyConstants.SWITCH_OPEN){
                    vo.setSms(true);
                    vo.setSmsId(h.getSmsId());
                    vo.setSmsTempId(templateMessageMap.get(h.getSmsId().longValue()).getTempId());
                }
                cache.put(h.getMark(), vo);
            }
            return notificationList.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_NOTIFICATION_TEMPLATE;
    }

    @Override
    public Class<?> getProviderType() {
        return NotificationTemplateVo.class;
    }

    public void setNotificationService(NotificationServiceImpl notificationService) {
        this.notificationService = notificationService;
    }

    private NotificationServiceImpl notificationService;
}
