package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.PushCacheProvider;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;

public class LocalPushCacheProvider extends AbstractCacheProvider<String> implements PushCacheProvider {

    public LocalPushCacheProvider(){
        this.runClearDirtyCacheTask();
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        // 初始化不需要加载数据，缓存中数据2分钟失效
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PUSH;
    }

    @Override
    public Class<?> getProviderType() {
        return String.class;
    }

    @Override
    public void put(String key, String value) {
        this.putCacheData(key, value, 60);
    }

    @Override
    public String get(String key) {
        return this.getCacheData(key);
    }

    private void runClearDirtyCacheTask(){
        logger.info("启动定时任务，定期清理过期的用户登录信息，但暂未实现。");
    }
}
