package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.model.po.S_user_core;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;

import java.util.List;

/**
 * 本地用户缓存实现。
 * @author 时克英
 * @date 2022-11-06
 */
public class LocalUserCacheProvider extends AbstractCacheProvider<S_user_core> implements UserCacheProvider {

    private UserServiceImpl userService = null;

    public void setUserService(UserServiceImpl userService) {
        this.userService = userService;
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<S_user_core> hosts = this.userService.selectAll(new S_user_core());
        if(!StringUtils.isEmptyList(hosts)){
            for(S_user_core h : hosts){
                cache.put(String.valueOf(h.getId()), h);
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_USER;
    }

    @Override
    public Class<?> getProviderType() {
        return S_user_core.class;
    }

    @Override
    public S_user_core getUser(long userId) {
        return this.getCacheData(String.valueOf(userId));
    }

    @Override
    public void updateUser(S_user_core user_core) {
        this.updateCacheData(String.valueOf(user_core.getId()), user_core);
    }

    @Override
    public void removeUser(long userId) {
        this.removeCacheData(String.valueOf(userId));
    }

    @Override
    public void putUser(S_user_core user_core) {
        this.putCacheData(String.valueOf(user_core.getId()), user_core);
    }
}
