package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.WechatCacheProvider;
import com.iplatform.base.WechatConstants;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;

public class LocalWechatCache extends AbstractCacheProvider<String> implements WechatCacheProvider {

    @Override
    public String getMiniAccessToken() {
        return this.getCacheData(WechatConstants.REDIS_WECAHT_MINI_ACCESS_TOKEN_KEY);
    }

    @Override
    public String getJsApiTicket() {
        return this.getCacheData(WechatConstants.REDIS_PUBLIC_JS_API_TICKET);
    }

    @Override
    public String getPublicAccessToken() {
//        throw new UnsupportedOperationException("请使用Redis实现");
        return this.getCacheData(WechatConstants.REDIS_WECAHT_PUBLIC_ACCESS_TOKEN_KEY);
    }

    @Override
    public void putPublicAccessToken(String value, long expiredSeconds) {
//        throw new UnsupportedOperationException("请使用Redis实现");
        this.putCacheData(WechatConstants.REDIS_WECAHT_PUBLIC_ACCESS_TOKEN_KEY, value, expiredSeconds);
    }

    @Override
    public void putJsApiTicket(String value) {
//        throw new UnsupportedOperationException("请使用Redis实现");
        this.putCacheData(WechatConstants.REDIS_PUBLIC_JS_API_TICKET, value, WechatConstants.REDIS_PUBLIC_JS_API_TICKET_EXPRESS);
    }

    @Override
    public void putMiniAccessToken(String value, long expiredSeconds) {
        this.putCacheData(WechatConstants.REDIS_WECAHT_MINI_ACCESS_TOKEN_KEY, value, expiredSeconds);
    }

    @Override
    public void removeMiniAccessToken() {
        this.removeCacheData(WechatConstants.REDIS_WECAHT_MINI_ACCESS_TOKEN_KEY);
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_WECHAT;
    }

    @Override
    public Class<?> getProviderType() {
        return String.class;
    }
}
