package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.walker.cache.Cache;
import com.walker.support.redis.cache.RedisCacheProvider;

/**
 * 验证码(Redis)缓存实现。
 * @date 2022-11-07
 */
public class RedisCaptchaCacheProvider extends RedisCacheProvider<String> {

    public RedisCaptchaCacheProvider(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_CAPTCHA;
    }

    @Override
    public Class<?> getProviderType() {
        return String.class;
    }

    @Override
    protected int loadDataToCache(Cache cache){
        // 无需启动加载数据
        return 0;
    }
}
