package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.model.po.S_host;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.PubService;
import com.walker.support.redis.cache.RedisCacheProvider;

import java.util.List;

/**
 * 主机资源缓存(Redis方式)实现。
 * @author 时克英
 * @date 2022-09-20
 */
public class RedisHostCacheProvider extends RedisCacheProvider<S_host> {

    private PubService pubService;

    public RedisHostCacheProvider(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_HOST;
    }

    @Override
    public Class<?> getProviderType() {
        return S_host.class;
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<S_host> hosts = this.pubService.selectAll(new S_host());
        if(!StringUtils.isEmptyList(hosts)){
            // ------------------------- 切换成普通缓存步骤：3
            if(this.isUseRedis()){
                // 如果redis中缓存数量和数据库中不一致（少），则清空redis缓存，重新加载数据库数据到缓存中。
                long totalCache = cache.getPersistentSize();
                if(totalCache < hosts.size()){
                    logger.info("redis缓存中用户数量小于实际用户，需要清空缓存重新加载! cache = " + totalCache + ", db = " + hosts.size());
                    cache.clear();

                    for(S_host h : hosts){
                        cache.put(String.valueOf(h.getId()), h);
                    }
                }
            }//------------------------------------------
            return hosts.size();
        }
        return 0;
    }

    public void setPubService(PubService pubService) {
        this.pubService = pubService;
    }
}
