package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.PushCacheProvider;
import com.walker.support.redis.cache.RedisCacheProvider;

public class RedisPushCacheProvider extends RedisCacheProvider<String> implements PushCacheProvider {

    public RedisPushCacheProvider(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_PUSH;
    }

    @Override
    public Class<?> getProviderType() {
        return String.class;
    }

    @Override
    public void put(String key, String value) {
        this.putCacheData(key, value, 60);
    }

    @Override
    public String get(String key) {
        return this.getCacheData(key);
    }
}
