package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.SystemGroupCache;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.model.po.S_group;
import com.iplatform.model.po.S_group_data;
import com.iplatform.model.vo.SystemGroupVo;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;

import java.util.ArrayList;
import java.util.List;

public class RedisSystemGroupCache extends RedisCacheProvider<SystemGroupVo> implements SystemGroupCache {

    public RedisSystemGroupCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public SystemGroupVo get(int id) {
        return this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(SystemGroupVo category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(SystemGroupVo category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        List<S_group> hosts = this.groupService.selectAll(new S_group());
        if(!StringUtils.isEmptyList(hosts)){
            if(this.isUseRedis()){
                // 如果redis中缓存数量和数据库中不一致（少），则清空redis缓存，重新加载数据库数据到缓存中。
                long totalCache = cache.getPersistentSize();
                if(totalCache != hosts.size()){
                    logger.info("redis缓存中用户数量小于实际用户，需要清空缓存重新加载! cache = " + totalCache + ", db = " + hosts.size());
                    cache.clear();

                    List<SystemGroupVo> groupVoList = new ArrayList<>(hosts.size());
                    List<S_group_data> groupDataList = this.groupService.queryAllGroupDataList();
                    for(S_group h : hosts){
                        groupVoList.add(new SystemGroupVo(h));
                    }

                    if(!StringUtils.isEmptyList(groupDataList)){
                        for(S_group_data data : groupDataList){
                            for(SystemGroupVo vo : groupVoList){
                                if(data.getGid().intValue() == vo.getId().intValue()){
                                    vo.addGroupData(data);
                                }
                            }
                        }
                    }

                    for(SystemGroupVo h : groupVoList){
                        cache.put(String.valueOf(h.getId()), h);
                    }
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_GROUP;
    }

    @Override
    public Class<?> getProviderType() {
        return SystemGroupVo.class;
    }

    public void setGroupService(GroupServiceImpl groupService) {
        this.groupService = groupService;
    }

    private GroupServiceImpl groupService;
}
