package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.UserLoginCache;
import com.iplatform.model.po.S_user_login;
import com.walker.support.redis.cache.RedisCacheProvider;

public class RedisUserLoginCache extends RedisCacheProvider<S_user_login> implements UserLoginCache {

    public RedisUserLoginCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public S_user_login getUserLogin(String loginId) {
        return this.getCacheData(loginId);
    }

    @Override
    public void updateUserLogin(S_user_login user_login) {
        this.updateCacheData(user_login.getUser_name(), user_login);
    }

    @Override
    public void removeUserLogin(String loginId) {
        this.removeCacheData(loginId);
    }

    @Override
    public void putUserLogin(S_user_login user_login) {
        this.putCacheData(user_login.getUser_name(), user_login);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_USER_LOGIN;
    }

    @Override
    public Class<?> getProviderType() {
        return S_user_login.class;
    }
}
