package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.DefaultUserPrincipal;
import com.iplatform.base.VariableConstants;
import com.iplatform.base.util.TokenUtils;
import com.iplatform.base.util.UserUtils;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;

/**
 * Redis实现的用户登录缓存提供者。
 * @author 时克英
 * @date 2022-11-14
 */
public class RedisUserOnlineProvider extends RedisCacheProvider<String> implements UserOnlineProvider {

    public RedisUserOnlineProvider(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_ONLINE_USER;
    }

    @Override
    public Class<?> getProviderType() {
        return String.class;
    }

    @Override
    protected int loadDataToCache(Cache cache){
        // 因为登录缓存在redis中，因此启动时无需重新加载
        return 0;
    }

    @Override
    public UserPrincipal<?> getUserPrincipal(String token) {
//        UserPrincipal<?> userPrincipal = this.getCacheData(token);
        String userJson = this.getCacheData(token);
        if(StringUtils.isEmpty(userJson)){
            logger.warn("缓存未获取登录信息, token=" + token);
            return null;
        }
        try {
            // 由于存在泛型，因此直接调用 JsonUtils.jsonStringToObject() 方法报错。
            // 只能转成JSON自定义解析反序列化。2022-11-15
//            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode(userJson);
//            return this.createUserPrincipal(objectNode);
            return UserUtils.toUserPrincipal(userJson);
//            return JsonUtils.jsonStringToObject(userJson, DefaultUserPrincipal.class);
        } catch (Exception e) {
            throw new RuntimeException("缓存获取登录信息错误, token=" + token + ", " + e.getMessage(), e);
        }

//        if(userPrincipal == null){
//            logger.warn("UserOnlineProvider 缓存用户不存在, token = " + token);
//            return null;
//        }
//        return userPrincipal;
    }

    @Override
    public boolean cacheUserPrincipal(String token, UserPrincipal<?> userPrincipal) {
        logger.debug("redis写入登录用户缓存(token=uuid): " + token);
        try {
            String userJson = JsonUtils.objectToJsonString((DefaultUserPrincipal)userPrincipal);
//            logger.info(userJson);
            this.putCacheData(token, userJson, TokenUtils.acquireCacheUserExpiredSeconds(VariableConstants.DEFAULT_TOKEN_EXPIRED_MINUTES));
        } catch (Exception e) {
            throw new RuntimeException("登录信息写入缓存错误: " + e.getMessage(), e);
        }
        return true;
    }

    @Override
    public boolean updateUserPrincipalTimeStamp(String token) {
        return false;
    }

    @Override
    public boolean removeUserPrincipal(String token) {
        this.removeCacheData(token);
        return true;
    }

    /*private DefaultUserPrincipal createUserPrincipal(ObjectNode objectNode){
        JsonNode userInfoNode = objectNode.get("userInfo");
        S_user_core user_core = new S_user_core();
        user_core.setId(userInfoNode.get("id").asLong());
        user_core.setUser_name(userInfoNode.get("user_name").asText());
        user_core.setPassword(userInfoNode.get("password").asText());
        user_core.setDept_id(userInfoNode.get("dept_id").asLong());
        user_core.setNick_name(userInfoNode.get("nick_name").asText());
        user_core.setUser_type(userInfoNode.get("user_type").asInt());
        user_core.setCreate_time(new Date(userInfoNode.get("create_time").asLong()));
        user_core.setOrg_id(userInfoNode.get("org_id").asLong());
        user_core.setStatus(userInfoNode.get("status").asInt());
        user_core.setDel_flag(userInfoNode.get("del_flag").asInt());
        if(!JsonUtils.isEmptyObject(userInfoNode.get("sex"))){
            user_core.setSex(userInfoNode.get("sex").asText());
        } else {
            user_core.setSex("2");
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("phonenumber"))){
            user_core.setPhonenumber(userInfoNode.get("phonenumber").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("avatar"))){
            user_core.setAvatar(userInfoNode.get("avatar").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("email"))){
            user_core.setEmail(userInfoNode.get("email").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("remark"))){
            user_core.setRemark(userInfoNode.get("remark").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("create_by"))){
            user_core.setCreate_by(userInfoNode.get("create_by").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("login_date"))){
            user_core.setLogin_date(new Date(userInfoNode.get("login_date").asLong()));
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("login_ip"))){
            user_core.setLogin_ip(userInfoNode.get("login_ip").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("update_by"))){
            user_core.setUpdate_by(userInfoNode.get("update_by").asText());
        }
        if(!JsonUtils.isEmptyObject(userInfoNode.get("update_time"))){
            user_core.setUpdate_time(new Date(userInfoNode.get("update_time").asLong()));
        }
        JsonNode roleIdListJson = objectNode.get("roleIdList");
        List<String> roleList = new ArrayList<>(4);
        if(roleIdListJson.isArray()){
            for(Iterator<JsonNode> it = roleIdListJson.iterator(); it.hasNext();){
                roleList.add(it.next().asText());
            }
        }

        DefaultUserPrincipal defaultUserPrincipal = new DefaultUserPrincipal(user_core);
        defaultUserPrincipal.setRoleIdList(roleList);

        // 2022-12-21
        JsonNode dataScopeMap = objectNode.get("dataScopeMap");
        if(dataScopeMap != null){
            String functionMenuId = null;
            for(Iterator<String> it = dataScopeMap.fieldNames(); it.hasNext();){
                functionMenuId = it.next();
                defaultUserPrincipal.addDataScope(functionMenuId, dataScopeMap.get(functionMenuId).asText());
            }
        }

        return defaultUserPrincipal;
    }*/
}
