package com.iplatform.base.cache;

import com.iplatform.base.Constants;
import com.iplatform.base.WechatCacheProvider;
import com.iplatform.base.WechatConstants;
import com.walker.support.redis.cache.RedisCacheProvider;

/**
 * 微信相关缓存，由于存在票据、token等过期设置，因此测试也需要使用Redis方式。
 * @author 时克英
 * @date 2023-07-16
 */
public class RedisWechatCache extends RedisCacheProvider<String> implements WechatCacheProvider {

    public RedisWechatCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public String getMiniAccessToken() {
        return this.getCacheData(WechatConstants.REDIS_WECAHT_MINI_ACCESS_TOKEN_KEY);
    }

    @Override
    public String getJsApiTicket() {
        return this.getCacheData(WechatConstants.REDIS_PUBLIC_JS_API_TICKET);
    }

    @Override
    public String getPublicAccessToken() {
        return this.getCacheData(WechatConstants.REDIS_WECAHT_PUBLIC_ACCESS_TOKEN_KEY);
    }

    @Override
    public void putPublicAccessToken(String value, long expiredSeconds) {
        this.putCacheData(WechatConstants.REDIS_WECAHT_PUBLIC_ACCESS_TOKEN_KEY, value, expiredSeconds);
    }

    @Override
    public void putJsApiTicket(String value) {
        this.putCacheData(WechatConstants.REDIS_PUBLIC_JS_API_TICKET, value, WechatConstants.REDIS_PUBLIC_JS_API_TICKET_EXPRESS);
    }

    @Override
    public void putMiniAccessToken(String value, long expiredSeconds) {
        this.putCacheData(WechatConstants.REDIS_WECAHT_MINI_ACCESS_TOKEN_KEY, value, expiredSeconds);
    }

    @Override
    public void removeMiniAccessToken() {
        this.removeCacheData(WechatConstants.REDIS_WECAHT_MINI_ACCESS_TOKEN_KEY);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_WECHAT;
    }

    @Override
    public Class<?> getProviderType() {
        return String.class;
    }
}
