package com.iplatform.base.callback;

import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.ApplicationCallback;
import com.walker.web.UserPrincipal;


/**
 * 用户登录后的回调函数定义。
 * @author 时克英
 * @date 2023-008-18
 */
public interface AfterLoginCallback extends ApplicationCallback {

    /**
     * 登录成功时回调
     * @param requestLogin
     * @param userPrincipal
     */
    void onSuccess(RequestLogin requestLogin, UserPrincipal<S_user_core> userPrincipal);

    /**
     * 登录失败回调
     * @param requestLogin
     */
    void onFailed(RequestLogin requestLogin);

    /**
     * 退出系统回调
     * @param userId
     */
    void onLogout(String userId);

    /**
     * 默认平台仅能配置一个登录回调。
     * @return
     */
    default boolean supportMultiple() {
        return false;
    }
}
