package com.iplatform.base.callback;

import com.iplatform.base.PlatformLoginCallback;
import com.iplatform.base.VariableConstants;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.util.TokenUtils;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import com.walker.web.UserOnlineProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralLoginCallback implements PlatformLoginCallback {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public boolean isValidateCaptcha() {
        // web端登录一定存在验证码方式
        CaptchaProvider<CaptchaResult> captchaProvider = this.getCaptchaProvider();
        if(captchaProvider == null){
            logger.warn("登录回调'{}'没有配置'验证码提供者':CaptchaProvider", this.getClass().getName());
            return false;
        }
        CaptchaType captchaType = captchaProvider.getCaptchaType();
        logger.debug("captchaType = {}", captchaType);
        if(captchaType == CaptchaType.Slide){
            // 滑动验证，不需要后台校验
            logger.debug("slide 验证类型，后台不需要校验。");
            return false;
        }
        if(captchaType == CaptchaType.SmsCode){
            // 短信验证码，作为密码使用，不需要后台验证
            return false;
        }
        if(captchaType == CaptchaType.None){
            // 移动端目前账号、密码登录，没有任何验证码。2023-03-20
            return false;
        }
        // 其他都需要验证
        return true;
    }

    @Override
    public boolean supportMultiple() {
        return true;
    }

    /**
     * 该方法暂未使用，目前看不需要，所有退出操作都是清空token和登录缓存，后续看其他是否存在不一样情况。2023-01-26
     * @param token 客户端提交的token
     * @throws TokenException
     */
    @Deprecated
    @Override
    public void onLogout(String token) throws TokenException {
        String data = tokenGenerator.validateToken(token, VariableConstants.TOKEN_SECRET);
        String[] userIdAndKey = TokenUtils.getUserIdAndKey(data);
        this.userOnlineProvider.removeUserPrincipal(userIdAndKey[1]);
        logger.debug("用户 logout success: " + userIdAndKey[0]);
    }

    public void setUserOnlineProvider(UserOnlineProvider userOnlineProvider) {
        this.userOnlineProvider = userOnlineProvider;
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setUserService(UserServiceImpl userService) {
        this.userService = userService;
    }

    @Override
    public CaptchaProvider<CaptchaResult> getCaptchaProvider() {
        return captchaProvider;
    }

    @Override
    public void setCaptchaProvider(CaptchaProvider<CaptchaResult> captchaProvider) {
        this.captchaProvider = captchaProvider;
    }

    private CaptchaProvider<CaptchaResult> captchaProvider;
    protected UserServiceImpl userService = null;
    private UserOnlineProvider userOnlineProvider;
    private TokenGenerator tokenGenerator;
}
