package com.iplatform.base.callback;

import com.iplatform.base.util.menu.SystemMenu;
import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.ApplicationCallback;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 控制用户自定义加载系统菜单的回调定义。
 * @author 时克英
 * @date 2023-10-12
 */
public interface SecurityCallback extends ApplicationCallback {

    /**
     * 由业务向 MAP 中存储自己的用户信息，返回给前端。
     * @param data
     * @param user
     * @date 2023-10-14
     */
    void acquireUserInfo(Map<String, Object> data, S_user_core user);

    /**
     * 用户自定义加载功能权限，平台会调用该函数。
     * <pre>
     *     1) 在接口：getInfo()中调用。
     * </pre>
     * @param userCore
     * @param menuIdList
     * @return
     */
    Set<String> loadUserPermission(S_user_core userCore, List<String> menuIdList);

    /**
     * 用户自定义加载菜单列表，平台会回调该函数。
     * <pre>
     *     1) 在接口：getMenu()中调用。
     * </pre>
     * @param userCore 平台用户对象
     * @param roleIdList 角色ID集合
     * @return
     */
    List<SystemMenu> loadUserMenu(S_user_core userCore, List<String> roleIdList);

    /**
     * 默认平台仅能配置一个登录回调。
     * @return
     */
    default boolean supportMultiple() {
        return false;
    }
}
