package com.iplatform.base.callback;

import com.iplatform.base.pojo.RequestLogin;
import com.iplatform.model.po.S_user_core;
import com.walker.web.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAfterLoginCallback implements AfterLoginCallback{

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void onSuccess(RequestLogin requestLogin, UserPrincipal<S_user_core> userPrincipal) {
        logger.info("用户成功登录，回调：{}", requestLogin);
    }

    @Override
    public void onFailed(RequestLogin requestLogin) {

    }

    @Override
    public void onLogout(String userId) {
        logger.info("用户成功退出，回调：{}", userId);
    }

}
