package com.iplatform.base.captcha;

import com.iplatform.base.util.CaptchaUtils;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

import javax.imageio.ImageIO;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCaptchaProvider implements CaptchaProvider<CaptchaResult> {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    protected final ResourceLoader resourceLoader = new DefaultResourceLoader();

    // 所有验证图片都加入内存，降低磁盘读写
//    protected Map<String, BufferedImage> imageCacheMap = new ConcurrentHashMap<>(32);

    protected final Random bgRandom = new Random();
    protected final Random blockRandom = new Random();

    protected static final String IMAGE_TYPE_PNG = "png";
    protected static final String IMAGE_TYPE_JPG = "jpg";
    // 该字段含义不详！
    protected static int captchaInterferenceOptions = 0;

    protected static final int SLIP_OFFSET = 6;

    protected static String waterMark = "我的水印";
    protected static String waterMarkFontStr = "WenQuanZhengHei.ttf";
    protected Font waterMarkFont;//水印字体

    @Override
    public boolean validateCaptcha(CaptchaResult data) {
        String verifyKey = CaptchaUtils.getVerifyKey(data);
        String xSource = this.captchaCacheProvider.getCacheData(verifyKey);
        if(StringUtils.isEmpty(xSource)){
            logger.error("拼图验证信息已失效!");
            return false;
        }

        // 删除缓存的验证码
        // 注意：这里不能删除缓存验证结果，因为登录接口还要再次使用。2023-04-07
//        this.captchaCacheProvider.removeCacheData(verifyKey);

        // 前端传过来的数字，可能包含小数，所以不能直接'Integer.parseInt'转换。
        int xValidate = Double.valueOf(data.getCode()).intValue();
        int xGenerate = Integer.parseInt(xSource);

        if ((xValidate - xGenerate) <= SLIP_OFFSET && (xValidate - xGenerate) >= -SLIP_OFFSET) {
            return true;
        }
        return false;
    }

    BufferedImage loadBufferedImage(String imageName) throws Exception{
        if(StringUtils.isEmpty(imageName)){
            throw new IllegalArgumentException("验证码图片名称参数缺失：imageName");
        }
        return ImageIO.read(resourceLoader.getResource(imageName).getInputStream());
    }

    public void setCaptchaCacheProvider(CacheProvider<String> captchaCacheProvider) {
        this.captchaCacheProvider = captchaCacheProvider;
    }

    protected CacheProvider<String> captchaCacheProvider;
}
