package com.iplatform.base.captcha;

import com.iplatform.base.util.CaptchaUtils;
import com.iplatform.core.BeanContextAware;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.kaptcha.SimpleKaptchaProvider;
import com.walker.web.CaptchaResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 重新实现验证码 验证方法，之前一直没有使用，这次统一使用提供者验证。
 * @author 时克英
 * @date 2023-04-07
 */
public class DefaultCaptchaProvider extends SimpleKaptchaProvider {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean validateCaptcha(CaptchaResult data) {
        String verifyKey = CaptchaUtils.getVerifyKey(data);
        CacheProvider<String> captchaCacheProvider = (CacheProvider<String>) BeanContextAware.getBeanByName("captchaCacheProvider");
        String codeGenerate = captchaCacheProvider.getCacheData(verifyKey);
        if(StringUtils.isEmpty(codeGenerate)){
            logger.error("DefaultCaptchaProvider：图像验证信息已失效!");
            return false;
        }

        if(codeGenerate.equalsIgnoreCase(data.getCode())){
            logger.debug("图像验证通过：{}", data.getCode());
            return true;
        }
        return false;
    }
}
