package com.iplatform.base.captcha;

import com.iplatform.base.util.VerifyImgUtil;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;

import java.awt.image.BufferedImage;
import java.util.Map;

/**
 * 拼图滑动验证码，提供者实现。<p></p>
 * 所有验证拼图图像在初始化时加载如内存，提高性能。
 * @author 时克英
 * @date 2023-04-06
 */
//public class JigsawCaptchaProvider implements CaptchaProvider<CaptchaResult> {
public class JigsawCaptchaProvider extends AbstractCaptchaProvider {

    private final static int IMAGE_BG_SIZE = 10;
    private final static int IMAGE_BLOCK_SIZE = 21;

    /**
     * 不能缓存图片，因为要在原图上扣背景，因此必须每次加载原始图片。
     * @date 2023-06-27
     */
    public JigsawCaptchaProvider(){
//        String imageName = null;
//        try{
//            BufferedImage image = null;
//            for(int i=1; i<IMAGE_BG_SIZE+2; i++){
//                imageName = "images/jigsaw_bg/" + i + ".jpg";
//                image = this.loadBufferedImage(imageName);
//                this.imageCacheMap.put(imageName, image);
//            }
//
//            for(int j=1; j<IMAGE_BLOCK_SIZE+2; j++){
//                imageName = "images/jigsaw_block/" + j + ".png";
//                image = this.loadBufferedImage(imageName);
//                this.imageCacheMap.put(imageName, image);
//            }
//            logger.info("共加载验证码拼图文件'{}'个", this.imageCacheMap.size());
//
//        } catch (Exception ex){
//            throw new ApplicationRuntimeException("验证码图片加载错误，imageName=" + imageName, ex);
//        }
    }

    @Override
    public CaptchaResult generateCaptcha(Object param) {
        int n = this.bgRandom.nextInt(10) + 1; //背景
        int m = this.blockRandom.nextInt(21) + 1; //滑块

        try{
            //原图
            String sourceName = "images/jigsaw_bg/" + n + ".jpg";
//        BufferedImage sourceImg = this.imageCacheMap.get(sourceName);
            BufferedImage sourceImg = this.loadBufferedImage(sourceName);
            //抠图模版
            String blockName = "images/jigsaw_block/" + m + ".png";
            BufferedImage templateImg = this.loadBufferedImage(blockName);
            if(sourceImg == null || templateImg == null){
                logger.error("未加载到拼图验证图片资源:" + sourceName + ", or " + blockName);
                return null;
            }

            int w = templateImg.getWidth();
            int h = templateImg.getHeight();

            //获取抠图坐标
            Map<String, Integer> coord = VerifyImgUtil.generateCutoutCoordinates(w, h);
            int x = coord.get("x");
            int y = coord.get("y");

            //获取抠图图形矩阵
            int[][] templateData = VerifyImgUtil.getTemplateData(templateImg);
            //抠图
            Map<String, BufferedImage> r = VerifyImgUtil.initSlidingBlock(sourceImg, templateData, x, y, w, h);

//            Map result = new HashMap();
//            result.put("y", y);
//            result.put("slider", VerifyImgUtil.getBase64(r.get("newTemplateImg")));
//            result.put("bg", VerifyImgUtil.getBase64(r.get("newSourceImg")));

            JigsawResult jigsawResult = new JigsawResult();
            jigsawResult.setX(x);
            jigsawResult.setY(y);
            jigsawResult.setImageSourceBase64(VerifyImgUtil.getBase64(r.get("newSourceImg")));
            jigsawResult.setImageBlockBase64(VerifyImgUtil.getBase64(r.get("newTemplateImg")));
            return jigsawResult;

        } catch (Exception ex){
            logger.error("处理拼图验证图像错误, blockName={}", ex);
            return null;
        }
    }

    @Override
    public CaptchaType getCaptchaType() {
        return CaptchaType.Jigsaw;
    }
}
