package com.iplatform.base.captcha;

import com.iplatform.base.util.CaptchaUtils;
import com.iplatform.core.BeanContextAware;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.kaptcha.WordCaptchaProvider;
import com.walker.web.CaptchaResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 普通字符验证码实现。
 * @author 时克英
 * @date 2023-05-12
 */
public class TextCaptchaProvider extends WordCaptchaProvider {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean validateCaptcha(CaptchaResult data) {
//        String verifyKey = CaptchaUtils.getVerifyKey(data);
        CacheProvider<String> captchaCacheProvider = (CacheProvider<String>) BeanContextAware.getBeanByName("captchaCacheProvider");
        String codeGenerate = captchaCacheProvider.getCacheData(CaptchaUtils.getVerifyKey(data));
        if(StringUtils.isEmpty(codeGenerate)){
            logger.error("DefaultCaptchaProvider：图像验证信息已失效!");
            return false;
        }

        if(codeGenerate.equalsIgnoreCase(data.getCode())){
            logger.debug("文本验证通过：{}", data.getCode());
            return true;
        }
        return false;
    }
}
