package com.iplatform.base.config;

import com.iplatform.base.DeptCacheProvider;
import com.iplatform.base.RootConfigBean;
import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.cache.DictCacheProvider;
import com.iplatform.base.callback.PlatformCallbackPostProcessor;
import com.iplatform.base.di.PlatformDataImportEngine;
import com.walker.cache.CacheProvider;
import com.walker.cache.CacheProviderPostProcessor;
import com.walker.push.PushManager;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 所有 <code>BeanPostProcessor</code> 对象必须统一在这里处理，不能混合到业务Bean，否则会提示:<br>
 * ### is not eligible for getting processed by all BeanPostProcessors.
 * <pre>
 *     1)注意:该配置对象并没有使用 <code>@Configuration</code> 注解，
 *     2)它将被作为普通工厂类来加载普通Bean对象，
 *     3)以上内容为解决问题时的描述记录，暂未删除
 *     ===========================================================
 * </pre>
 * @date 2023-01-05
 */
@Configuration
public class BeanPostProcessorConfig {

    /**
     * 配置该Bean，不会直接使用，仅仅使系统控制器能被自动组装。
     * @param platformCallbackPostProcessor
     * @param userCacheProvider
     * @param deptCacheProvider
     * @param dictCacheProvider
     * @param platformDataImportEngine
     * @return
     * @date 2023-03-10
     */
    @Bean
    public RootConfigBean rootConfigBean(PlatformCallbackPostProcessor platformCallbackPostProcessor
        , UserCacheProvider userCacheProvider, DeptCacheProvider deptCacheProvider, DictCacheProvider dictCacheProvider
        , PlatformDataImportEngine platformDataImportEngine
        , PushManager pushManager, CaptchaProvider<CaptchaResult> smsCaptchaProvider, CacheProvider<String> captchaCacheProvider){
        RootConfigBean rootConfigBean = new RootConfigBean();
        rootConfigBean.setCallbackPostProcessor(platformCallbackPostProcessor);
        rootConfigBean.setDeptCacheProvider(deptCacheProvider);
        rootConfigBean.setUserCacheProvider(userCacheProvider);
        rootConfigBean.setDictCacheProvider(dictCacheProvider);
        rootConfigBean.setPlatformDataImportEngine(platformDataImportEngine);
        // 2023-04-25
        rootConfigBean.setPushManager(pushManager);
        // 2023-06-28
        rootConfigBean.setSmsCaptchaProvider(smsCaptchaProvider);
        rootConfigBean.setCaptchaCacheProvider(captchaCacheProvider);
        rootConfigBean.startup();
        return rootConfigBean;
    }

    /**
     * 配置平台回调接口处理器对象，加载系统所有实现回调的集合。
     * @return
     * @date 2023-01-05
     */
    @Bean
//    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public PlatformCallbackPostProcessor platformCallbackPostProcessor(){
        return new PlatformCallbackPostProcessor();
    }

    /**
     * 注册该对象后，可以启动时收集系统注册的缓存对象，并通过 SimpleCacheManager 获取缓存对象。
     * @return 返回缓存提供者后处理器<p></p>具体使用：
     * {@link com.walker.cache.SimpleCacheManager#getCacheProvider(Class)}
     */
    @Bean
    public CacheProviderPostProcessor cacheProviderPostProcessor(){
        return new CacheProviderPostProcessor();
    }

}
