package com.iplatform.base.config;

import com.iplatform.base.cache.DictCacheProvider;
import com.iplatform.base.cache.FormCacheProvider;
import com.iplatform.base.cache.MenuCacheProvider;
import com.iplatform.base.service.CodeServiceImpl;
import com.iplatform.base.service.ConfigFormServiceImpl;
import com.iplatform.base.service.MenuServiceImpl;
import com.iplatform.core.PlatformConfiguration;
import com.walker.cache.CacheProviderPostProcessor;
import org.springframework.context.annotation.Bean;

/**
 * 平台缓存配置基础。
 * @author 时克英
 * @date 2022-09-21
 */
public abstract class CacheConfiguration extends PlatformConfiguration {

    /**
     * 添加缓存参数配置，追加了机构用户缓存参数
     * @return
     * @date 2023-07-17
     */
    @Bean
    public CacheProperties cacheProperties(){
        return new CacheProperties();
    }

    /**
     * 系统自定义表单缓存配置。
     * @param configFormService
     * @return
     * @date 2023-05-18
     */
    @Bean
    public FormCacheProvider formCacheProvider(ConfigFormServiceImpl configFormService){
        FormCacheProvider formCacheProvider = new FormCacheProvider();
        formCacheProvider.setConfigFormService(configFormService);
        return formCacheProvider;
    }

    /**
     * 数据字典缓存配置，直接内存缓存，在集群环境下无法实现动态编辑（如果编辑需要实现Redis方式）。
     * @param codeService
     * @return
     * @date 2023-03-10
     */
    @Bean
    public DictCacheProvider dictCacheProvider(CodeServiceImpl codeService){
        DictCacheProvider dictCacheProvider = new DictCacheProvider();
        dictCacheProvider.setCodeService(codeService);
        return dictCacheProvider;
    }

    @Bean
    public MenuCacheProvider menuCacheProvider(MenuServiceImpl menuService){
        MenuCacheProvider menuCacheProvider = new MenuCacheProvider();
        menuCacheProvider.setMenuService(menuService);
        return menuCacheProvider;
    }
}
