package com.iplatform.base.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 缓存参数
 * @author 时克英
 * @date 2023-07-17 添加
 */
@ConfigurationProperties(prefix = "iplatform.cache")
public class CacheProperties {

    /**
     * 是否启用 Redis
     * @return
     */
    public boolean isRedisEnabled() {
        return redisEnabled;
    }

    public void setRedisEnabled(boolean redisEnabled) {
        this.redisEnabled = redisEnabled;
    }

    /**
     * 机构用户是否很庞大，如果是则缓存中会关闭初始化加载，同时机构树也不会放入缓存，2023-07-17
     * @return
     * @date 2023-07-17
     */
    public boolean isOrgUserBig() {
        return orgUserBig;
    }

    public void setOrgUserBig(boolean orgUserBig) {
        this.orgUserBig = orgUserBig;
    }

    /**
     * redis 缓存是否重建，如果是则启动时会删除redis已有缓存，并重新执行默认加载方法。
     * @return
     * @date 2023-08-26
     */
    public boolean isRedisRebuild() {
        return redisRebuild;
    }

    public void setRedisRebuild(boolean redisRebuild) {
        this.redisRebuild = redisRebuild;
    }

    private boolean redisRebuild = false;
    private boolean redisEnabled = false;
    private boolean orgUserBig = false;
}
