package com.iplatform.base.config;

import com.iplatform.base.captcha.BlockPuzzleCaptchaProvider;
import com.iplatform.base.captcha.JigsawCaptchaProvider;
import com.iplatform.base.captcha.SmsCaptchaProvider;
import com.iplatform.core.PlatformConfiguration;
import com.walker.cache.CacheProvider;
import com.walker.infrastructure.utils.ClassUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.PushManager;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Constructor;

@Configuration
public class CaptchaConfig extends PlatformConfiguration {

    @Bean
    public CaptchaProperties captchaProperties(){
        return new CaptchaProperties();
    }

    /**
     * 移动端使用的拼图验证组件实现，目前想替换已有老的，PC端正在尝试替换。
     * @param captchaCacheProvider
     * @return
     * @date 2023-06-27
     */
    @Bean
    public BlockPuzzleCaptchaProvider blockPuzzleCaptchaProvider(CacheProvider<String> captchaCacheProvider){
        BlockPuzzleCaptchaProvider captchaProvider = new BlockPuzzleCaptchaProvider();
        captchaProvider.setCaptchaCacheProvider(captchaCacheProvider);
        return captchaProvider;
    }

    /**
     * 拼图滑块验证，提供者定义。
     * @return
     * @date 2023-04-06
     * @date 2023-06-27 准备使用新的：JigsawMobile拼图验证组件替换该组件。
     */
    @Deprecated
    @Bean
    public JigsawCaptchaProvider jigsawCaptchaProvider(CacheProvider<String> captchaCacheProvider){
        JigsawCaptchaProvider jigsawCaptchaProvider = new JigsawCaptchaProvider();
        jigsawCaptchaProvider.setCaptchaCacheProvider(captchaCacheProvider);
        return jigsawCaptchaProvider;
    }

    /**
     * 短信验证码生成提供者。
     * @return
     * @date 2023-01-27
     * @date 2023-04-25 重构对象，底层推送由'PushManger'完成。
     */
    @Bean("smsCaptchaProvider")
    public SmsCaptchaProvider smsCaptchaProvider(PushManager pushManager){
        SmsCaptchaProvider smsCaptchaProvider = new SmsCaptchaProvider();
        smsCaptchaProvider.setPushManager(pushManager);
        return smsCaptchaProvider;
    }
//    public CaptchaProvider<CaptchaResult> smsCaptchaProvider(CaptchaProperties captchaProperties){
//        String smsCaptchaClass = captchaProperties.getSmsCaptchaClass();
//        if(StringUtils.isEmpty(smsCaptchaClass)){
//            throw new IllegalArgumentException("短信验证码提供者类未配置: CaptchaProperties --> smsCaptchaClass");
//        }
//        try {
//            logger.info("创建'短信验证码提供者' = " + smsCaptchaClass);
//            Class<?> captchaProviderClass = ClassUtils.forName(smsCaptchaClass, CaptchaConfig.class.getClassLoader());
//            Constructor<CaptchaProvider<CaptchaResult>> constructor = (Constructor<CaptchaProvider<CaptchaResult>>)captchaProviderClass.getConstructor();
//            return constructor.newInstance();
//        } catch (Exception e) {
//            throw new RuntimeException("创建'短信验证码'提供者实例异常:" + e.getMessage(), e);
//        }
//    }

    /**
     * 简单图像验证码生成提供者
     * @return
     * @author 时克英
     * @date 2022-11-06
     * @date 2023-01-27 通过配置文件，动态创建提供者对象。
     */
    @Bean("imageCaptchaProvider")
    public CaptchaProvider<CaptchaResult> imageCaptchaProvider(CaptchaProperties captchaProperties){
        String imageCaptchaClass = captchaProperties.getImageCaptchaClass();
        if(StringUtils.isEmpty(imageCaptchaClass)){
            throw new IllegalArgumentException("图像验证码提供者类未配置: CaptchaProperties --> imageCaptchaClass");
        }
        try {
            logger.info("创建'图像验证码提供者' = " + imageCaptchaClass);
            Class<?> captchaProviderClass = ClassUtils.forName(imageCaptchaClass, CaptchaConfig.class.getClassLoader());
            Constructor<CaptchaProvider<CaptchaResult>> constructor = (Constructor<CaptchaProvider<CaptchaResult>>)captchaProviderClass.getConstructor();
            return constructor.newInstance();
        } catch (Exception e) {
            throw new RuntimeException("创建'图像验证码'提供者实例异常:" + e.getMessage(), e);
        }
//        return new SimpleKaptchaProvider();
    }
}
