package com.iplatform.base.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 验证码配置相关参数。
 * @author 时克英
 * @date 2023-01-27
 */
@ConfigurationProperties(prefix = "iplatform.captcha")
public class CaptchaProperties {

    /**
     * 图像验证码实现类对象，如: com.walker.support.kaptcha.SimpleKaptchaProvider
     * @return
     */
    public String getImageCaptchaClass() {
        return imageCaptchaClass;
    }

    public void setImageCaptchaClass(String imageCaptchaClass) {
        this.imageCaptchaClass = imageCaptchaClass;
    }

    /**
     * 短信验证码提供者实现类对象
     * @return
     */
    @Deprecated
    public String getSmsCaptchaClass() {
        return smsCaptchaClass;
    }

    public void setSmsCaptchaClass(String smsCaptchaClass) {
        this.smsCaptchaClass = smsCaptchaClass;
    }

    private String imageCaptchaClass;

    @Deprecated
    private String smsCaptchaClass;
}
