package com.iplatform.base.config;

import com.iplatform.base.LocalDatabaseMetaEngine;
import com.iplatform.base.di.PlatformDataImportEngine;
import com.iplatform.base.di.PlatformExcelTemplateGenerator;
import com.walker.di.excel.ExcelTemplateGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 数据导入、导出配置。
 * @author 时克英
 * @date 2023-02-07
 */
@Configuration
public class DataImportConfig {

    /**
     * 配置导入数据引擎对象，负责整个Excel导入功能。
     * @param excelTemplateGenerator
//     * @param fileOperateSpi 文件操作服务提供者接口
     * @param fileProperties 文件管理配置属性
     * @return
     * @date 2023-02-07
     * @date 2023-02-15
     */
    @Bean
    public PlatformDataImportEngine dataImportEngine(ExcelTemplateGenerator excelTemplateGenerator
//            , FileOperateSpi fileOperateSpi
            , FileProperties fileProperties){
        PlatformDataImportEngine dataImportEngine = new PlatformDataImportEngine();
//        dataImportEngine.setSaveFileRoot("d:/tmp/");
        /** 这里只能设置本机磁盘路径，因为导入文件都是本机操作(到数据库)的，不会涉及服务集群。2023-02-15 */
        dataImportEngine.setSaveFileRoot(fileProperties.getFileRoot());
        dataImportEngine.setTemplateGenerator(excelTemplateGenerator);
        return dataImportEngine;
    }

    /**
     * Excel导入系统根据表名自动生成导入模板。
     * @param localDatabaseMetaEngine
     * @return
     * @date 2023-02-07
     */
    @Bean
    public ExcelTemplateGenerator excelTemplateGenerator(LocalDatabaseMetaEngine localDatabaseMetaEngine){
        PlatformExcelTemplateGenerator excelTemplateGenerator = new PlatformExcelTemplateGenerator();
        excelTemplateGenerator.setLocalDatabaseMetaEngine(localDatabaseMetaEngine);
        return excelTemplateGenerator;
    }
}
