package com.iplatform.base.config;

import com.iplatform.base.LocalDatabaseMetaEngine;
import com.iplatform.core.PlatformConfiguration;
import com.walker.connector.LocalAddress;
import com.walker.jdbc.JdbcInspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 数据库元数据相关配置。
 * @author 时克英
 * @date 2023-02-06
 */
@Configuration
public class DatabaseMetaConfig extends PlatformConfiguration {

    private JdbcInspector jdbcInspector;

    @Autowired
    public DatabaseMetaConfig(JdbcInspector jdbcInspector){
        this.jdbcInspector = jdbcInspector;
    }

    /**
     * 创建本地数据库元数据引擎(单例)对象。
     * @return
     * @date 2022-11-22
     * @date 2023-02-06 从 iplatform-jdbc-generator 模块迁移过来。
     */
    @Bean
    public LocalDatabaseMetaEngine localDatabaseMetaEngine(){
        LocalAddress localAddress = new LocalAddress(jdbcInspector.getPrimaryDataSourceMeta());

        LocalDatabaseMetaEngine localDatabaseMetaEngine = new LocalDatabaseMetaEngine();
        localDatabaseMetaEngine.setDatabaseType(jdbcInspector.getPrimaryDatabaseType());
        localDatabaseMetaEngine.setLocalAddress(localAddress);
        logger.info("创建: localDatabaseMetaEngine = " + localDatabaseMetaEngine);
        return localDatabaseMetaEngine;
    }

}
