package com.iplatform.base.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "iplatform.file")
public class FileProperties {

    public String getFileRoot() {
        return fileRoot;
    }

    public void setFileRoot(String fileRoot) {
        this.fileRoot = fileRoot;
    }

    /**
     * 调用远程上传文件，是否按照本地方式处理。
     * <pre>
     *     1)该选项为了适应没有FTP等服务的情况，特别是在开发过程，如果设置为：true 则调用远程上传方法后文件仍然保存在本地。
     *     2)如果生产环境存在合适的文件存储服务，则需要设置为：false
     * </pre>
     * @return
     * @date 2023-07-03
     */
    public boolean isRemoteAsLocal() {
        return remoteAsLocal;
    }

    public void setRemoteAsLocal(boolean remoteAsLocal) {
        this.remoteAsLocal = remoteAsLocal;
    }

    private boolean remoteAsLocal = true;
    private String fileRoot = null;

}
