package com.iplatform.base.config;

import com.iplatform.base.CategoryCacheProvider;
import com.iplatform.base.NotificationTemplateCache;
import com.iplatform.base.PushCacheProvider;
import com.iplatform.base.SystemGroupCache;
import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.UserLoginCache;
import com.iplatform.base.cache.LocalCaptchaCacheProvider;
import com.iplatform.base.cache.LocalCategoryCacheProvider;
import com.iplatform.base.cache.LocalDeptCacheProvider;
import com.iplatform.base.cache.LocalHostCacheProvider;
import com.iplatform.base.cache.LocalNotificationTemplateCache;
import com.iplatform.base.cache.LocalPushCacheProvider;
import com.iplatform.base.cache.LocalSystemGroupCache;
import com.iplatform.base.cache.LocalUserCacheProvider;
import com.iplatform.base.cache.LocalUserLoginCache;
import com.iplatform.base.cache.LocalUserOnlineProvider;
import com.iplatform.base.service.CategoryServiceImpl;
import com.iplatform.base.service.ConfigArgumentServiceImpl;
import com.iplatform.base.service.DeptServiceImpl;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.base.service.NotificationServiceImpl;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.support.DatabaseArgumentsManager;
import com.iplatform.model.po.S_host;
import com.walker.cache.CacheProvider;
import com.walker.jdbc.service.PubService;
import com.walker.web.UserOnlineProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix = "iplatform.cache", name = "redis-enabled", havingValue = "false", matchIfMissing = true)
//@ConditionalOnMissingClass("com.walker.support.redis.cache.RedisCacheProvider")
public class LocalCacheConfig extends CacheConfiguration {

    /**
     * 通知提醒模板配置缓存。
     * @param notificationService
     * @return
     * @date 2023-08-25
     */
    @Bean
    public NotificationTemplateCache notificationTemplateCache(NotificationServiceImpl notificationService){
        LocalNotificationTemplateCache cache = new LocalNotificationTemplateCache();
        cache.setNotificationService(notificationService);
        return cache;
    }

    /**
     * 用户登录记录缓存，用于判断登录策略。
     * @return
     * @date 2023-07-11
     */
    @Bean
    public UserLoginCache userLoginCache(){
        LocalUserLoginCache cache = new LocalUserLoginCache();
        return cache;
    }

    @Bean
    public SystemGroupCache systemGroupCache(GroupServiceImpl groupService){
        LocalSystemGroupCache cache = new LocalSystemGroupCache();
        cache.setGroupService(groupService);
        return cache;
    }

    /**
     * 平台分类数据，本地缓存实现。
     * @param categoryService
     * @return
     * @date 2023-05-17
     */
    @Bean
    public CategoryCacheProvider localCategoryCacheProvider(CategoryServiceImpl categoryService){
        LocalCategoryCacheProvider categoryCacheProvider = new LocalCategoryCacheProvider();
        categoryCacheProvider.setCategoryService(categoryService);
        return categoryCacheProvider;
    }

    /**
     * 推送提醒临时数据缓存定义。
     * @return
     * @date 2023-04-27
     */
    @Bean
    public PushCacheProvider pushCacheProvider(){
        return new LocalPushCacheProvider();
    }

    @Bean
    public UserOnlineProvider userOnlineProvider(){
        return new LocalUserOnlineProvider();
    }

    @Bean("captchaCacheProvider")
    public CacheProvider<String> cacheProviderCaptchaLocal(){
        return new LocalCaptchaCacheProvider();
    }

    /**
     * 创建基于内存的机构缓存管理器。
     * @param deptService
     * @return
     * @date 2022-12-05
     */
    @Bean
    public LocalDeptCacheProvider localDeptCacheProvider(DeptServiceImpl deptService){
        LocalDeptCacheProvider localDeptCacheProvider = new LocalDeptCacheProvider();
        localDeptCacheProvider.setDeptService(deptService);
        return localDeptCacheProvider;
    }

    /**
     * 基于内存实现的 ArgumentsManager 管理器。
     * @param configArgumentService
     * @return
     * @date 2022-11-29
     */
    @Bean
    public DatabaseArgumentsManager databaseArgumentsManager(ConfigArgumentServiceImpl configArgumentService){
        DatabaseArgumentsManager databaseArgumentsManager = new DatabaseArgumentsManager();
        databaseArgumentsManager.setConfigArgumentService(configArgumentService);
        return databaseArgumentsManager;
    }

    /**
     * 加载本地用户缓存
     * @param userService
     * @return
     * @date 2022-11-06
     */
    @Bean
    public UserCacheProvider userCacheProviderForLocal(UserServiceImpl userService){
        LocalUserCacheProvider localUserCacheProvider = new LocalUserCacheProvider();
        localUserCacheProvider.setUserService(userService);
        return localUserCacheProvider;
    }

    /**
     * 默认加载缓存(内存方式)
     * @param pubService
     * @return
     * @throws Exception
     * @date 2022-09-20
     */
    @Bean
    public CacheProvider<S_host> cacheProviderHostLocal(PubService pubService) throws Exception{
        LocalHostCacheProvider localHostCacheProvider = new LocalHostCacheProvider();
        localHostCacheProvider.setPubService(pubService);
        /** 注意：这里无需手动调用FactoryBean的初始化方法，spring会自动调用 2022-09-20 */
//        hostLocalCacheProvider.afterPropertiesSet();
        logger.info("初始化缓存: HostLocalCacheProvider");
        return localHostCacheProvider;
    }

//    /**
//     * 如果存在配置项(打开redis缓存)，同时存在包(walker-support-redis)则使用redis缓存对象。
//     * @param pubService
//     * @return
//     * @throws Exception
//     * @date 2022-09-20
//     */
//    @Bean
//    @ConditionalOnProperty(prefix = "iplatform.cache", name = "redis-enabled", havingValue = "true", matchIfMissing = false)
//    @ConditionalOnClass({RedisCacheProvider.class})
//    public CacheProvider<S_host> cacheProviderHostRedis(PubService pubService) throws Exception{
//        HostRedisCacheProvider hostRedisCacheProvider = new HostRedisCacheProvider();
//        hostRedisCacheProvider.setPubService(pubService);
////        hostRedisCacheProvider.afterPropertiesSet();
//        logger.info("初始化缓存: HostRedisCacheProvider");
//        return hostRedisCacheProvider;
//    }
}
