package com.iplatform.base.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

@ConfigurationProperties(prefix = "iplatform.security")
public class LoginStrategyProperties {

    /**
     * 返回登录策略名称集合。
     * @return
     */
    public List<String> getLoginStrategyList() {
        return loginStrategyList;
    }

    public void setLoginStrategyList(List<String> loginStrategyList) {
        this.loginStrategyList = loginStrategyList;
    }

    public long getTokenExpireWeb() {
        return tokenExpireWeb;
    }

    public void setTokenExpireWeb(long tokenExpireWeb) {
        this.tokenExpireWeb = tokenExpireWeb;
    }

    public long getTokenExpireMobile() {
        return tokenExpireMobile;
    }

    public void setTokenExpireMobile(long tokenExpireMobile) {
        this.tokenExpireMobile = tokenExpireMobile;
    }

    private long tokenExpireWeb = 120;              // PC端默认2小时
    private long tokenExpireMobile = 60 * 24 * 15;  // 移动端默认15天
    private List<String> loginStrategyList = null;
}
