package com.iplatform.base.config;

import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.push.DefaultDySmsPush;
import com.iplatform.core.PlatformConfiguration;
import com.walker.push.PushManager;
import com.walker.push.alidy.DySmsPush;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass({DySmsPush.class})
public class PushAliSmsConfig extends PlatformConfiguration {

    /**
     * 配置阿里大鱼短信，如果依赖库存在就会启动。
     * @param userCacheProvider
     * @return
     * @date 2023-04-24
     * @date 2023-04-27 异步监听器由管理器统一设置
     */
    @Bean
    public DefaultDySmsPush defaultDySmsPush(UserCacheProvider userCacheProvider, PushManager pushManager){
        DefaultDySmsPush smsPush = new DefaultDySmsPush();
        // 推送监听器，由管理器统一设置，2023-04-27
//        smsPush.setPushStatusListener(pushStatusListener);
        smsPush.setUserCacheProvider(userCacheProvider);
//        smsPush.setAccessKeyId("LTAI5t7qnuVZVbHKPC6bz5K2");
//        smsPush.setAccessKeySecret("XxkaeawDDzbHPg4clP164CrGVbZ5KZ");
//        smsPush.setSignName("河南省新店物流");
        smsPush.setRegion("cn-hangzhou");
        smsPush.setAccessKeyId("LTAI5tEATHGRi6TYJ2WEJ4SB");
        smsPush.setAccessKeySecret("gmuZX1MRU9gltvR1ckGhvbPFhCPqKS");
        smsPush.setSignName("河南省正开能源有限公司");
        smsPush.startup();
        logger.debug("创建：大鱼短信推送者");

        pushManager.register(smsPush);
        return smsPush;
    }
}
