package com.iplatform.base.config;

import com.iplatform.base.PushCacheProvider;
import com.iplatform.base.push.DefaultPushListener;
import com.iplatform.base.push.DefaultPushManager;
import com.iplatform.base.push.MockSmsPush;
import com.iplatform.base.push.SystemPush;
import com.iplatform.base.service.PushServiceImpl;
import com.iplatform.base.util.NotificationUtils;
import com.iplatform.core.PlatformConfiguration;
import com.walker.push.PushManager;
import com.walker.push.PushStatusListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class PushConfig extends PlatformConfiguration {

    /**
     * 推送参数配置
     * @return
     */
    @Bean
    public PushProperties pushProperties(){
        return new PushProperties();
    }

    /**
     * 配置推送管理器对象
     * @return
     * @date 2023-04-21
     */
    @Bean
    public PushManager pushManager(ThreadPoolTaskExecutor threadPoolTaskExecutor
            , PushProperties pushProperties, PushStatusListener pushStatusListener){
        DefaultPushManager pushManager = new DefaultPushManager();
        pushManager.setSmsId(pushProperties.getSmsPushName());
        pushManager.setSmsTemplateCode(pushProperties.getSmsTemplateCode());

        Object[] data = NotificationUtils.acquireMessagePushRules(pushProperties.getMessageType());
        pushManager.setMessageParallel((Boolean) data[0]);

        String[] indexList = (String[])data[1];
        if(indexList == null || indexList.length == 0){
            throw new IllegalStateException("推送（普通消息）配置规则不存在!");
        }

        List<String> channelNameList = new ArrayList<>(4);
        for(String index: indexList){
            channelNameList.add(index);
        }
        pushManager.setMessageChannelNames(channelNameList);
        pushManager.setThreadPoolTaskExecutor(threadPoolTaskExecutor);
        pushManager.setAsyncListener(pushStatusListener);

        //
        pushManager.setMailFrom(pushProperties.getMailFrom());

        return pushManager;
    }

/*    *//**
     * 配置默认短信推送实现（一个通道可以有多个实现）
     * @return
     * @date 2023-04-24
     *//*
    @Bean
    public Pushable mailPush(PushManager pushManager, PushProperties pushProperties, UserCacheProvider userCacheProvider){
        DefaultMailPush mailPush = new DefaultMailPush();
//        mailPush.setMailServerHost("smtp.126.com");
//        mailPush.setMailServerPort("25");
//        mailPush.setFromAddress("hnzzzhsl@126.com");
//        mailPush.setFromPassword("UWBUXNLFJEANRCXX");
        mailPush.setMailServerHost(pushProperties.getMailServer());
        mailPush.setMailServerPort("25");
        mailPush.setFromAddress(pushProperties.getMailFrom());
        mailPush.setFromPassword(pushProperties.getMailPassword());
        mailPush.setUserCacheProvider(userCacheProvider);
        mailPush.startup();

        pushManager.register(mailPush);
        return mailPush;
    }*/

    /**
     * 配置推送监听器，仅异步推送者需要使用
     * @return
     * @date 2023-04-24
     */
    @Bean
    public PushStatusListener pushStatusListener(PushCacheProvider pushCacheProvider, PushServiceImpl pushService){
        DefaultPushListener pushListener = new DefaultPushListener();
        pushListener.setPushService(pushService);
        pushListener.setPushCacheProvider(pushCacheProvider);
        return pushListener;
    }

    /**
     * 注册'模拟短信'推送者
     * @param pushManager
     * @return
     * @date 2023-04-24
     */
    @Bean
    public MockSmsPush mockSmsPush(PushManager pushManager){
        MockSmsPush mockSmsPush = new MockSmsPush();
        mockSmsPush.startup();
        pushManager.register(mockSmsPush);
        return mockSmsPush;
    }

    /**
     * 注册默认的'系统消息'推送者，其实并不推送。
     * @param pushManager
     * @return
     * @date 2023-04-24
     */
    @Bean
    public SystemPush systemPush(PushManager pushManager){
        SystemPush systemPush = new SystemPush();
        systemPush.startup();
        pushManager.register(systemPush);
        return systemPush;
    }
}
