package com.iplatform.base.config;

import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.push.DefaultMailPush;
import com.walker.push.PushManager;
import com.walker.push.Pushable;
import com.walker.push.mail.MailPush;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 邮件推送，选配，从主配置中分离出来。
 * @author 时克英
 * @date 2023-05-07
 */
@Configuration
@ConditionalOnClass({MailPush.class})
public class PushMailConfig {

    /**
     * 配置默认短信推送实现（一个通道可以有多个实现）
     * @return
     * @date 2023-04-24
     */
    @Bean
    public Pushable mailPush(PushManager pushManager, PushProperties pushProperties, UserCacheProvider userCacheProvider){
        DefaultMailPush mailPush = new DefaultMailPush();
//        mailPush.setMailServerHost("smtp.126.com");
//        mailPush.setMailServerPort("25");
//        mailPush.setFromAddress("hnzzzhsl@126.com");
//        mailPush.setFromPassword("UWBUXNLFJEANRCXX");
        mailPush.setMailServerHost(pushProperties.getMailServer());
        mailPush.setMailServerPort("25");
        mailPush.setFromAddress(pushProperties.getMailFrom());
        mailPush.setFromPassword(pushProperties.getMailPassword());
        mailPush.setUserCacheProvider(userCacheProvider);
        mailPush.startup();

        pushManager.register(mailPush);
        return mailPush;
    }

}
