package com.iplatform.base.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "iplatform.push")
public class PushProperties {

    /**
     * 短信推送者名称，用于配置切换。
     * <pre>
     *     即：Pushable.getId();
     * </pre>
     * @return
     */
    public String getSmsPushName() {
        return smsPushName;
    }

    public void setSmsPushName(String smsPushName) {
        this.smsPushName = smsPushName;
    }

    /**
     * 短信验证码（发送）模板ID，一般云平台会查到。
     * @return
     */
    public String getSmsTemplateCode() {
        return smsTemplateCode;
    }

    public void setSmsTemplateCode(String smsTemplateCode) {
        this.smsTemplateCode = smsTemplateCode;
    }

    /**
     * 配置普通业务消息，推送方式规则。
     * <p>对于一般业务提醒（不包括：邮件、短信），推送的方式。推送者ID组合</p>
     * <pre>
     *     1) tcp && web_socket && wx && system 表示这几种通道同时推送
     *     2) tcp || web_socket || wx || system 表示这几种通道只要一个推送就OK
     * </pre>
     * @return
     * @date 2023-04-26
     */
    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMailServer() {
        return mailServer;
    }

    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    public String getMailFrom() {
        return mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public String getMailPassword() {
        return mailPassword;
    }

    public void setMailPassword(String mailPassword) {
        this.mailPassword = mailPassword;
    }

    private String mailServer;
    private String mailFrom;
    private String mailPassword;
    private String messageType;
    private String smsTemplateCode;
    private String smsPushName;
}
