package com.iplatform.base.config;

import com.walker.push.PushManager;
import com.walker.push.Pushable;
import com.walker.push.wx.WeixinPublicPush;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * 微信公众号推送独立配置，只有引入模块才会生效。
 * <p>walker-push-wx-public</p>
 * @author 时克英
 * @date 2023-08-23
 */
@Configuration
@ConditionalOnClass({WeixinPublicPush.class})
public class PushWechatConfig {

    /**
     * 微信公众号推送配置。
     * @param restTemplate
     * @param pushManager
     * @return
     */
    @Bean
    public Pushable wechatPublicPush(RestTemplate restTemplate, PushManager pushManager){
        WeixinPublicPush push = new WeixinPublicPush();
        push.setRestTemplate(restTemplate);
        push.startup();

        pushManager.register(push);
        return push;
    }
}
