package com.iplatform.base.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "iplatform.rest")
public class RestTemplateProperties {

    /**
     * 连接保持活动的时间，默认600秒
     * @return
     */
    public long getKeepAliveDurationSeconds() {
        return keepAliveDurationSeconds;
    }

    public void setKeepAliveDurationSeconds(long keepAliveDurationSeconds) {
        this.keepAliveDurationSeconds = keepAliveDurationSeconds;
    }

    /**
     * 最大空闲连接数量，默认：200
     * @return
     */
    public long getMaxIdleConnections() {
        return maxIdleConnections;
    }

    public void setMaxIdleConnections(long maxIdleConnections) {
        this.maxIdleConnections = maxIdleConnections;
    }

    /**
     * 连接超时，默认：2秒
     * @return
     */
    public long getConnectTimeoutSeconds() {
        return connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(long connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    /**
     * 读超时，默认：3秒
     * @return
     */
    public long getReadTimeoutSeconds() {
        return readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(long readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    /**
     * 写超时，默认：3秒
     * @return
     */
    public long getWriteTimeoutSeconds() {
        return writeTimeoutSeconds;
    }

    public void setWriteTimeoutSeconds(long writeTimeoutSeconds) {
        this.writeTimeoutSeconds = writeTimeoutSeconds;
    }

    private long keepAliveDurationSeconds = 300;
    private long maxIdleConnections = 200;
    private long connectTimeoutSeconds = 2;
    private long readTimeoutSeconds = 3;
    private long writeTimeoutSeconds = 3;
}
